using System;
using System.Windows.Forms;
using Borland.Studio.ToolsAPI;
using BeWise.SharpBuilderTools.Gui;

namespace BeWise.SharpBuilderTools
{
	public class OTAOptions : BaseOTA
	{
		/**************************************************************/
		/*                       Protected
		/**************************************************************/

		protected void DoOptions(object aSender, EventArgs AEventArgs)
		{
			FrmOptions _Frm = new FrmOptions();
			if (_Frm.ShowDialog() == DialogResult.OK) {
				Main.SaveConfiguration();
				OTAAnt.SetMenuText();
			}
		}

		/**************************************************************/
		/*                       Public
		/**************************************************************/

		public override void IDERegister(out string[] aMenuNames, out int[] aMenuShortCuts) {
			IOTAMainMenuService _MenuService = null;
			IOTAMenuItem _MenuItem = null;

			_MenuService = (IOTAMainMenuService) BorlandIDE.GetService(typeof(IOTAMainMenuService));

			// Sep1
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "SepOptionMenu",
												 "-");
			// Options
			_MenuItem = _MenuService.AddMenuItem(Consts.SHARP_BUILDER_TOOLS_MENU_NAME,
												 OTAMenuItemLocation.otamlChild,
												 "OptionsMenu",
												 "Sharp Builder Tools Options...");
			_MenuItem.Enabled = true;
			_MenuItem.Executed += new EventHandler(DoOptions);

			aMenuNames = new string[] {"OptionMenu"};
			aMenuShortCuts = new int[] {0};
		}
	}
}
